'             SOLDERING IRON TIMER WITH RELAY - PICAXE 14M2
'                     (timer_iron2_14m2.bas)

power_up:' ------- initalise the microprocessor 
setfreq m16
b1 = 0: b2 = 0: b3 = 0: b4 = 0: w4 = 0: w5 = 0: w6 = 0: time = 0 
let dirsB = %00111111: let dirsC = %00010111
let pinsB = %00000000: let pinsC = %00000000
read b0,word w4: read b1,word w4
if w4 = 0 then: w4 = 2: write b0,word w4: write b1,word w4 endif
'goto set_default

set_default:'------ hold S2 at power up to change run-time
if PinC.3 = 0 then goto run_time
goto start_up

run_time:'--------- select from 1 of 10 default run-times 
pause 2
high C.4: low B.0: w4 = 2:   gosub pb_off' (20 sec)
high C.2: low C.4: w4 = 60:  gosub pb_off' (10 min)
high C.1: low C.2: w4 = 90:  gosub pb_off' (15 min)
high C.0: low C.1: w4 = 120: gosub pb_off' (20 min)
high B.5: low C.0: w4 = 150: gosub pb_off' (25 min)
high B.4: low B.5: w4 = 180: gosub pb_off' (30 min)
high B.3: low B.4: w4 = 210: gosub pb_off' (35 min)
high B.2: low B.3: w4 = 240: gosub pb_off' (40 min)
high B.1: low B.2: w4 = 270: gosub pb_off' (45 min)
high B.0: low B.1: w4 = 300: gosub pb_off' (50 min)
goto run_time

pb_off:'----------- delay waiting for S2 button to be released 
for b3 = 0 to 250
if pinC.3 = 1 then goto save_time
pause 10
next b3
return

save_time:'-------- save the selected run-time in EEPROM
write b0,word w4: write b1,word w4
pause 2500
'goto start_up

start_up:'--------- loop waiting for S2 button to be pushed
pause 100
if PinC.3 = 0 then goto drive_disp
goto start_up

step_delay:'------- adds the delay between the 10 steps
pause 100
if pinC.3 = 0 then goto drive_disp
let w6 = time
if w6 => w4 then: time = 0: return: endif
goto step_delay

drive_disp:'------- step the display from top to bottom
pause 10
pinsC = %00010000: pinsB = %00000000: gosub step_delay' (TOP)
pinsC = %00000100: pinsB = %00000000: gosub step_delay
pinsC = %00000010: pinsB = %00000000: gosub step_delay
pinsC = %00000001: pinsB = %00000000: gosub step_delay
pinsC = %00000000: pinsB = %00100000: gosub step_delay
pinsC = %00000000: pinsB = %00010000: gosub step_delay
pinsC = %00000000: pinsB = %00001000: gosub step_delay
pinsC = %00000000: pinsB = %00000100: gosub step_delay
pinsC = %00000000: pinsB = %00000010: gosub step_delay
pinsC = %00000000: pinsB = %00000001: gosub step_delay' (BOT)
goto alarm_mode 

alarm_mode:'------- beep and flash 6 times then power-down
for b3 = 1 to 6 
gosub alarm_tone
next b3
pinsC = %00000000: pinsB = %00000000
goto start_up

alarm_tone:'------- three tone beep as shut down warning	
high B.1
sound B.1,(60,80,20,80,60,80)
low B.1
'goto alarm_delay

alarm_delay:'------ add delay between beeps and check S2
for b4 = 1 to 35
if pinC.3 = 0 then goto drive_disp	
pause 100
next b4
return

'               Definition of variables
'-----------------------------------------------------
' b0 = low byte w0 (read/write)        
' b1 = high byte w0
' b3 = for/next loop
' b4 = for/next loop
' b8 = low byte w4 (run time)
' b9 = high byte w4        
' b12 = low byte w6 (seconds)
' b13 = high byte w6
'-----------------------------------------------------